global occupations advertisers bankers buildingcontractors busexecs carsalesmen clergy collegeteachers congressmen dentists doctors engineers funeraldirectors insurancesales journalists lawyers localpoliticians newspaperreporters nurses pharmacists policemen realtors senators statepoliticians stockbrokers tvreporters unionleaders
clear *
set mem 100m
use "gallup_honesty_raw.dta", clear

* Clean technical variables
rename date dt
format dt %d
gen str2 st=""
levelsof state, local(states)
qui foreach s of local states {
	local statelabel: value label state
	local st: label `statelabel' `s'
	replace st="`st'" if state==`s'
}
drop state
egen stid=group(st)
gen wt=.
levelsof dt, local(dates)
qui foreach d of local dates {
	summ weight if dt==`d'
	replace wt=weight/r(mean) if dt==`d'
}
drop weight 
rename race race_orig
gen race3=race_orig
replace race3=3 if race_orig>2 & race_orig<.
label define race3 1 "White" 2 "Black" 3 "Other"
label values race3 race3

* Organizing variables
gen year=year(dt)

* Rename and relabel and reorder variables
label define honesty 0 "Don't know" 1 "Very low" 2 "Low" 3 "Average" 4 "High" 5 "Very high"
order doctors-nurses, alphabetic
order survey year dt st wt sex age educ race3 race_orig
foreach v of global occupations {
	recode `v' (7=.) (6=0) (5=1) (4=2) (3=3) (2=4) (1=5)
	label values `v' honesty
	gen high_`v'=(`v'>=4) if `v'<.
	tab dt high_`v' [aw=wt], row nofreq /*check against published Gallup data*/
	drop high_`v'
	replace `v'=. if `v'==0	
}



* Label variables fully
la var advertisers "Advertising practitioners"
la var bankers "Bankers"
la var buildingcontractors "Building contractors"
la var busexecs "Business executives"
la var carsalesmen "Car salesmen / Car salespeople"
la var clergy "Clergy"
la var collegeteachers "College teachers"
la var congressmen "Congressmen / Members of Congress"
la var dentists "Dentists"
la var doctors "Medical doctors"
la var engineers "Engineers"
la var funeraldirectors "Funeral directors"
la var insurancesales "Insurance salespeople"
la var journalists "Journalists"
la var lawyers "Lawyers"
la var localpoliticians "Local officeholders"
la var newspaperreporters "Newspaper reporters"
la var nurses "Nurses"
la var pharmacists "Druggists or Pharmacists"
la var policemen "Policemen / Police officers"
la var realtors "Real estate agents"
la var senators "Senators"
la var statepoliticians "State officeholders"
la var stockbrokers "Stockbrokers"
la var tvreporters "TV reporters"
la var unionleaders "Labor union leaders"

* Keep only variables that are in the sample for 20 years or more (This was actually how data were collected)
foreach v of global occupations {
	qui tab year if `v'<.
	if r(r)<20 {
		di "Dropping `v'"
		drop `v'
	}
}
	
* Merge in state economic data
sort st year
merge m:1 st year using "..\State economic conditions\Unemployment", keep(match master)
drop _merge

la data "Please tell me how you would rate the honesty and ethical standards of people in these different fields--very high, high, average, low or very low?  How about: [random order]"
cd ..
save "Honesty_gallup", replace

